
; PICBASIC PRO(TM) Compiler 2.60A, (c) 1998, 2010 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"C:\PBP\16F627.INC"


; Define statements.
; C:\PBP\SAMPLES\VMON3_~2.PBP	00012	DEFINE HSER_CLROERR 1   'USART CLEAR OVERFLOW ERROR
#define		HSER_CLROERR		 1   
; C:\PBP\SAMPLES\VMON3_~2.PBP	00013	DEFINE HSER_TXSTA 24H   'SET USART TX STAUS REG 
#define		HSER_TXSTA		 24H   
; C:\PBP\SAMPLES\VMON3_~2.PBP	00014	DEFINE HSER_RCSTA 90H   'SET USART RC STAUS REG 
#define		HSER_RCSTA		 90H   
; C:\PBP\SAMPLES\VMON3_~2.PBP	00015	DEFINE HSER_BAUD 9600   'SET USART BAUD RATE
#define		HSER_BAUD		 9600   
; C:\PBP\SAMPLES\VMON3_~2.PBP	00016	define HSER_SPBRG 25    'SET PIC OSC FOR 9600 BAUD
#define		HSER_SPBRG		 25    

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

; C:\PBP\PBPPIC14.RAM      	00012	A00020	R0      VAR     WORD BANK0 SYSTEM       ' System Register
R0              		EQU	RAM_START + 000h
; C:\PBP\PBPPIC14.RAM      	00013	A00022	R1      VAR     WORD BANK0 SYSTEM       ' System Register
R1              		EQU	RAM_START + 002h
; C:\PBP\PBPPIC14.RAM      	00014	A00024	R2      VAR     WORD BANK0 SYSTEM       ' System Register
R2              		EQU	RAM_START + 004h
; C:\PBP\PBPPIC14.RAM      	00015	A00026	R3      VAR     WORD BANK0 SYSTEM       ' System Register
R3              		EQU	RAM_START + 006h
; C:\PBP\PBPPIC14.RAM      	00016	A00028	R4      VAR     WORD BANK0 SYSTEM       ' System Register
R4              		EQU	RAM_START + 008h
; C:\PBP\PBPPIC14.RAM      	00017	A0002A	R5      VAR     WORD BANK0 SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ah
; C:\PBP\PBPPIC14.RAM      	00018	A0002C	R6      VAR     WORD BANK0 SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Ch
; C:\PBP\PBPPIC14.RAM      	00019	A0002E	R7      VAR     WORD BANK0 SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Eh
; C:\PBP\PBPPIC14.RAM      	00020	A00030	R8      VAR     WORD BANK0 SYSTEM       ' System Register
R8              		EQU	RAM_START + 010h
; C:\PBP\PBPPIC14.RAM      	00026	A00032	FLAGS   VAR     BYTE BANK0 SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 012h
; C:\PBP\PBPPIC14.RAM      	00025	A00033	GOP     VAR     BYTE BANK0 SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 013h
; C:\PBP\PBPPIC14.RAM      	00022	A00034	RM1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP\PBPPIC14.RAM      	00024	A00035	RM2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC14.RAM      	00021	A00036	RR1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC14.RAM      	00023	A00037	RR2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\PBP\SAMPLES\VMON3_~2.PBP	00001	A00038	'****************************************************************
T1              		EQU	RAM_START + 018h
; C:\PBP\SAMPLES\VMON3_~2.PBP	00001	A0003A	'****************************************************************
T2              		EQU	RAM_START + 01Ah
; C:\PBP\BS2DEFS.BAS       	00057	A0003C	W0      VAR     WORD
_W0              		EQU	RAM_START + 01Ch
; C:\PBP\BS2DEFS.BAS       	00058	A0003E	W1      VAR     WORD
_W1              		EQU	RAM_START + 01Eh
; C:\PBP\BS2DEFS.BAS       	00067	A00040	W10     VAR     WORD
_W10             		EQU	RAM_START + 020h
; C:\PBP\BS2DEFS.BAS       	00068	A00042	W11     VAR     WORD
_W11             		EQU	RAM_START + 022h
; C:\PBP\BS2DEFS.BAS       	00069	A00044	W12     VAR     WORD
_W12             		EQU	RAM_START + 024h
; C:\PBP\BS2DEFS.BAS       	00059	A00046	W2      VAR     WORD
_W2              		EQU	RAM_START + 026h
; C:\PBP\BS2DEFS.BAS       	00060	A00048	W3      VAR     WORD
_W3              		EQU	RAM_START + 028h
; C:\PBP\BS2DEFS.BAS       	00061	A0004A	W4      VAR     WORD
_W4              		EQU	RAM_START + 02Ah
; C:\PBP\BS2DEFS.BAS       	00062	A0004C	W5      VAR     WORD
_W5              		EQU	RAM_START + 02Ch
; C:\PBP\BS2DEFS.BAS       	00063	A0004E	W6      VAR     WORD
_W6              		EQU	RAM_START + 02Eh
; C:\PBP\BS2DEFS.BAS       	00064	A00050	W7      VAR     WORD
_W7              		EQU	RAM_START + 030h
; C:\PBP\BS2DEFS.BAS       	00065	A00052	W8      VAR     WORD
_W8              		EQU	RAM_START + 032h
; C:\PBP\BS2DEFS.BAS       	00066	A00054	W9      VAR     WORD
_W9              		EQU	RAM_START + 034h
; C:\PBP\SAMPLES\VMON3_~2.PBP	00022	A00056	MAJOR VAR BYTE
_MAJOR           		EQU	RAM_START + 036h
; C:\PBP\SAMPLES\VMON3_~2.PBP	00023	A00057	MINOR VAR BYTE
_MINOR           		EQU	RAM_START + 037h
; C:\PBP\SAMPLES\VMON3_~2.PBP	00018	A000A0	RXDATA var BYTE (80)    'ALLOCATE 80 BYTES FOR USART RX DATA
_RXDATA          		EQU	RAM_START + 080h
; C:\PBP\16F627.BAS        	00020	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP\16F627.BAS        	00021	PORTH   VAR     PORTA
_PORTH           		EQU	 PORTA
; C:\PBP\16F627.BAS        	00022	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP\16F627.BAS        	00023	TRISH   VAR     TRISA
_TRISH           		EQU	 TRISA
; C:\PBP\BS2DEFS.BAS       	00014	INS     VAR     PORTL
_INS             		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00015	OUTS    VAR     PORTL
_OUTS            		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00017	INL     VAR     PORTL
_INL             		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00018	INH     VAR     PORTH
_INH             		EQU	_PORTH
; C:\PBP\BS2DEFS.BAS       	00020	OUTL    VAR     PORTL
_OUTL            		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00021	OUTH    VAR     PORTH
_OUTH            		EQU	_PORTH
; C:\PBP\BS2DEFS.BAS       	00071	B0      VAR     W0.LOWBYTE
_B0              		EQU	_W0
; C:\PBP\BS2DEFS.BAS       	00072	B1      VAR     W0.HIGHBYTE
_B1              		EQU	_W0 + 001h
; C:\PBP\BS2DEFS.BAS       	00073	B2      VAR     W1.LOWBYTE
_B2              		EQU	_W1
; C:\PBP\BS2DEFS.BAS       	00074	B3      VAR     W1.HIGHBYTE
_B3              		EQU	_W1 + 001h
; C:\PBP\BS2DEFS.BAS       	00075	B4      VAR     W2.LOWBYTE
_B4              		EQU	_W2
; C:\PBP\BS2DEFS.BAS       	00076	B5      VAR     W2.HIGHBYTE
_B5              		EQU	_W2 + 001h
; C:\PBP\BS2DEFS.BAS       	00077	B6      VAR     W3.LOWBYTE
_B6              		EQU	_W3
; C:\PBP\BS2DEFS.BAS       	00078	B7      VAR     W3.HIGHBYTE
_B7              		EQU	_W3 + 001h
; C:\PBP\BS2DEFS.BAS       	00079	B8      VAR     W4.LOWBYTE
_B8              		EQU	_W4
; C:\PBP\BS2DEFS.BAS       	00080	B9      VAR     W4.HIGHBYTE
_B9              		EQU	_W4 + 001h
; C:\PBP\BS2DEFS.BAS       	00081	B10     VAR     W5.LOWBYTE
_B10             		EQU	_W5
; C:\PBP\BS2DEFS.BAS       	00082	B11     VAR     W5.HIGHBYTE
_B11             		EQU	_W5 + 001h
; C:\PBP\BS2DEFS.BAS       	00083	B12     VAR     W6.LOWBYTE
_B12             		EQU	_W6
; C:\PBP\BS2DEFS.BAS       	00084	B13     VAR     W6.HIGHBYTE
_B13             		EQU	_W6 + 001h
; C:\PBP\BS2DEFS.BAS       	00085	B14     VAR     W7.LOWBYTE
_B14             		EQU	_W7
; C:\PBP\BS2DEFS.BAS       	00086	B15     VAR     W7.HIGHBYTE
_B15             		EQU	_W7 + 001h
; C:\PBP\BS2DEFS.BAS       	00087	B16     VAR     W8.LOWBYTE
_B16             		EQU	_W8
; C:\PBP\BS2DEFS.BAS       	00088	B17     VAR     W8.HIGHBYTE
_B17             		EQU	_W8 + 001h
; C:\PBP\BS2DEFS.BAS       	00089	B18     VAR     W9.LOWBYTE
_B18             		EQU	_W9
; C:\PBP\BS2DEFS.BAS       	00090	B19     VAR     W9.HIGHBYTE
_B19             		EQU	_W9 + 001h
; C:\PBP\BS2DEFS.BAS       	00091	B20     VAR     W10.LOWBYTE
_B20             		EQU	_W10
; C:\PBP\BS2DEFS.BAS       	00092	B21     VAR     W10.HIGHBYTE
_B21             		EQU	_W10 + 001h
; C:\PBP\BS2DEFS.BAS       	00093	B22     VAR     W11.LOWBYTE
_B22             		EQU	_W11
; C:\PBP\BS2DEFS.BAS       	00094	B23     VAR     W11.HIGHBYTE
_B23             		EQU	_W11 + 001h
; C:\PBP\BS2DEFS.BAS       	00095	B24     VAR     W12.LOWBYTE
_B24             		EQU	_W12
; C:\PBP\BS2DEFS.BAS       	00096	B25     VAR     W12.HIGHBYTE
_B25             		EQU	_W12 + 001h
_W0??LOWBYTE     		EQU	_W0
_W0??HIGHBYTE    		EQU	_W0 + 001h
_W1??LOWBYTE     		EQU	_W1
_W1??HIGHBYTE    		EQU	_W1 + 001h
_W2??LOWBYTE     		EQU	_W2
_W2??HIGHBYTE    		EQU	_W2 + 001h
_W3??LOWBYTE     		EQU	_W3
_W3??HIGHBYTE    		EQU	_W3 + 001h
_W4??LOWBYTE     		EQU	_W4
_W4??HIGHBYTE    		EQU	_W4 + 001h
_W5??LOWBYTE     		EQU	_W5
_W5??HIGHBYTE    		EQU	_W5 + 001h
_W6??LOWBYTE     		EQU	_W6
_W6??HIGHBYTE    		EQU	_W6 + 001h
_W7??LOWBYTE     		EQU	_W7
_W7??HIGHBYTE    		EQU	_W7 + 001h
_W8??LOWBYTE     		EQU	_W8
_W8??HIGHBYTE    		EQU	_W8 + 001h
_W9??LOWBYTE     		EQU	_W9
_W9??HIGHBYTE    		EQU	_W9 + 001h
_W10??LOWBYTE    		EQU	_W10
_W10??HIGHBYTE   		EQU	_W10 + 001h
_W11??LOWBYTE    		EQU	_W11
_W11??HIGHBYTE   		EQU	_W11 + 001h
_W12??LOWBYTE    		EQU	_W12
_W12??HIGHBYTE   		EQU	_W12 + 001h
#define _IN0             	_INL??0
#define _IN1             	_INL??1
#define _IN2             	_INL??2
#define _IN3             	_INL??3
#define _IN4             	_INL??4
#define _IN5             	_INL??5
#define _IN6             	_INL??6
#define _IN7             	_INL??7
#define _IN8             	_INH??0
#define _IN9             	_INH??1
#define _IN10            	_INH??2
#define _IN11            	_INH??3
#define _IN12            	_INH??4
#define _IN13            	_INH??5
#define _IN14            	_INH??6
#define _IN15            	_INH??7
#define _OUT0            	_OUTL??0
#define _OUT1            	_OUTL??1
#define _OUT2            	_OUTL??2
#define _OUT3            	_OUTL??3
#define _OUT4            	_OUTL??4
#define _OUT5            	_OUTL??5
#define _OUT6            	_OUTL??6
#define _OUT7            	_OUTL??7
#define _OUT8            	_OUTH??0
#define _OUT9            	_OUTH??1
#define _OUT10           	_OUTH??2
#define _OUT11           	_OUTH??3
#define _OUT12           	_OUTH??4
#define _OUT13           	_OUTH??5
#define _OUT14           	_OUTH??6
#define _OUT15           	_OUTH??7
#define _BIT0            	_B0??0
#define _BIT1            	_B0??1
#define _BIT2            	_B0??2
#define _BIT3            	_B0??3
#define _BIT4            	_B0??4
#define _BIT5            	_B0??5
#define _BIT6            	_B0??6
#define _BIT7            	_B0??7
#define _BIT8            	_B1??0
#define _BIT9            	_B1??1
#define _BIT10           	_B1??2
#define _BIT11           	_B1??3
#define _BIT12           	_B1??4
#define _BIT13           	_B1??5
#define _BIT14           	_B1??6
#define _BIT15           	_B1??7
#define _LED1            	_PORTB??4
#define _LED2            	_PORTB??5
#define _INL??0          	_INL, 000h
#define _INL??1          	_INL, 001h
#define _INL??2          	_INL, 002h
#define _INL??3          	_INL, 003h
#define _INL??4          	_INL, 004h
#define _INL??5          	_INL, 005h
#define _INL??6          	_INL, 006h
#define _INL??7          	_INL, 007h
#define _INH??0          	_INH, 000h
#define _INH??1          	_INH, 001h
#define _INH??2          	_INH, 002h
#define _INH??3          	_INH, 003h
#define _INH??4          	_INH, 004h
#define _INH??5          	_INH, 005h
#define _INH??6          	_INH, 006h
#define _INH??7          	_INH, 007h
#define _OUTL??0         	_OUTL, 000h
#define _OUTL??1         	_OUTL, 001h
#define _OUTL??2         	_OUTL, 002h
#define _OUTL??3         	_OUTL, 003h
#define _OUTL??4         	_OUTL, 004h
#define _OUTL??5         	_OUTL, 005h
#define _OUTL??6         	_OUTL, 006h
#define _OUTL??7         	_OUTL, 007h
#define _OUTH??0         	_OUTH, 000h
#define _OUTH??1         	_OUTH, 001h
#define _OUTH??2         	_OUTH, 002h
#define _OUTH??3         	_OUTH, 003h
#define _OUTH??4         	_OUTH, 004h
#define _OUTH??5         	_OUTH, 005h
#define _OUTH??6         	_OUTH, 006h
#define _OUTH??7         	_OUTH, 007h
#define _B0??0           	_B0, 000h
#define _B0??1           	_B0, 001h
#define _B0??2           	_B0, 002h
#define _B0??3           	_B0, 003h
#define _B0??4           	_B0, 004h
#define _B0??5           	_B0, 005h
#define _B0??6           	_B0, 006h
#define _B0??7           	_B0, 007h
#define _B1??0           	_B1, 000h
#define _B1??1           	_B1, 001h
#define _B1??2           	_B1, 002h
#define _B1??3           	_B1, 003h
#define _B1??4           	_B1, 004h
#define _B1??5           	_B1, 005h
#define _B1??6           	_B1, 006h
#define _B1??7           	_B1, 007h
#define _PORTB??4        	 PORTB, 004h
#define _PORTB??5        	 PORTB, 005h
#define _PIR1??5         	 PIR1, 005h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
	INCLUDE	"VMON3_~2.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"


; C:\PBP\16F627.BAS        	00012	BANK0   $0020, $007F
; C:\PBP\16F627.BAS        	00013	BANK1   $00A0, $00EF
; C:\PBP\16F627.BAS        	00014	BANK2   $0120, $014F
; C:\PBP\16F627.BAS        	00015	EEPROM  $2100, $217F
; C:\PBP\16F627.BAS        	00016	LIBRARY "PBPPIC14"

; C:\PBP\16F627.BAS        	00018	        include "PIC14EXT.BAS"

; C:\PBP\16F627.BAS        	00025	        include "PBPPIC14.RAM"

; C:\PBP\SAMPLES\VMON3_~2.PBP	00011	INCLUDE "BS2DEFS.BAS"

; C:\PBP\BS2DEFS.BAS       	00012	INCLUDE "MODEDEFS.BAS"  ' Include Mode definitions
; C:\PBP\MODEDEFS.BAS      	00014	Symbol T2400  = 0       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00015	Symbol T1200  = 1       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00016	Symbol T9600  = 2       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00017	Symbol T300   = 3       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00019	Symbol N2400  = 4       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00020	Symbol N1200  = 5       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00021	Symbol N9600  = 6       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00022	Symbol N300   = 7       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00024	Symbol OT2400 = 8       ' Open True
; C:\PBP\MODEDEFS.BAS      	00025	Symbol OT1200 = 9       ' Open True
; C:\PBP\MODEDEFS.BAS      	00026	Symbol OT9600 = 10      ' Open True
; C:\PBP\MODEDEFS.BAS      	00027	Symbol OT300  = 11      ' Open True
; C:\PBP\MODEDEFS.BAS      	00029	Symbol ON2400 = 12      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00030	Symbol ON1200 = 13      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00031	Symbol ON9600 = 14      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00032	Symbol ON300  = 15      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00036	Symbol MSBPRE = 0       ' MSB first, sample before clock
; C:\PBP\MODEDEFS.BAS      	00037	Symbol LSBPRE = 1       ' LSB first, sample before clock
; C:\PBP\MODEDEFS.BAS      	00038	Symbol MSBPOST = 2      ' MSB first, sample after clock
; C:\PBP\MODEDEFS.BAS      	00039	Symbol LSBPOST = 3      ' LSB first, sample after clock
; C:\PBP\MODEDEFS.BAS      	00042	Symbol LSBFIRST = 0     ' LSB first
; C:\PBP\MODEDEFS.BAS      	00043	Symbol MSBFIRST = 1     ' MSB first
; C:\PBP\MODEDEFS.BAS      	00047	Symbol CLS = 0
; C:\PBP\MODEDEFS.BAS      	00048	Symbol HOME = 1
; C:\PBP\MODEDEFS.BAS      	00049	Symbol BELL = 7
; C:\PBP\MODEDEFS.BAS      	00050	Symbol BKSP = 8
; C:\PBP\MODEDEFS.BAS      	00051	Symbol TAB = 9
; C:\PBP\MODEDEFS.BAS      	00052	Symbol CR = 13
; C:\PBP\MODEDEFS.BAS      	00056	Symbol UnitOn = %10010
; C:\PBP\MODEDEFS.BAS      	00057	Symbol UnitOff = %11010
; C:\PBP\MODEDEFS.BAS      	00058	Symbol UnitsOff = %11100
; C:\PBP\MODEDEFS.BAS      	00059	Symbol LightsOn = %10100
; C:\PBP\MODEDEFS.BAS      	00060	Symbol LightsOff = %10000
; C:\PBP\MODEDEFS.BAS      	00061	Symbol Dim = %11110
; C:\PBP\MODEDEFS.BAS      	00062	Symbol Bright = %10110
; C:\PBP\SAMPLES\VMON3_~2.PBP	00012	DEFINE HSER_CLROERR 1   'USART CLEAR OVERFLOW ERROR
; C:\PBP\SAMPLES\VMON3_~2.PBP	00013	DEFINE HSER_TXSTA 24H   'SET USART TX STAUS REG 
; C:\PBP\SAMPLES\VMON3_~2.PBP	00014	DEFINE HSER_RCSTA 90H   'SET USART RC STAUS REG 
; C:\PBP\SAMPLES\VMON3_~2.PBP	00015	DEFINE HSER_BAUD 9600   'SET USART BAUD RATE
; C:\PBP\SAMPLES\VMON3_~2.PBP	00016	define HSER_SPBRG 25    'SET PIC OSC FOR 9600 BAUD

; C:\PBP\SAMPLES\VMON3_~2.PBP	00021	PIR1 = $0C              'ASSIGN USART RX INTERUPT REG 
	MOVE?CB	00Ch, PIR1

; C:\PBP\SAMPLES\VMON3_~2.PBP	00025	LCDOUT $FE, 1                      'CLEAR LCD DISPLAY
	LCDOUT?C	0FEh
	LCDOUT?C	001h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00027	        FOR B4 = 1 TO 10                    'WAIT 10 SECOND FOR TBOLT TO BOOT
	MOVE?CB	001h, _B4
	LABEL?L	L00001	
	CMPGT?BCL	_B4, 00Ah, L00002

; C:\PBP\SAMPLES\VMON3_~2.PBP	00028	        high led1
	HIGH?T	_LED1

; C:\PBP\SAMPLES\VMON3_~2.PBP	00029	        high led2
	HIGH?T	_LED2

; C:\PBP\SAMPLES\VMON3_~2.PBP	00030	        PAUSE 500
	PAUSE?C	001F4h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00031	        low led1
	LOW?T	_LED1

; C:\PBP\SAMPLES\VMON3_~2.PBP	00032	        low led2
	LOW?T	_LED2

; C:\PBP\SAMPLES\VMON3_~2.PBP	00033	        pause 500
	PAUSE?C	001F4h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00034	        NEXT B4
	NEXT?BCL	_B4, 001h, L00001
	LABEL?L	L00002	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00036	MAIN:

	LABEL?L	_MAIN	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00037	        B0 = 0                      'RESET RXDATA ARRAY COUNT POINTER
	MOVE?CB	000h, _B0

; C:\PBP\SAMPLES\VMON3_~2.PBP	00038	        B1 = 1                      'RESET PARSING COUNT POINTER
	MOVE?CB	001h, _B1

; C:\PBP\SAMPLES\VMON3_~2.PBP	00039	        LCDOUT $FE,$80              'MOVE LCD CURSOR TO LINE 1 COL 1
	LCDOUT?C	0FEh
	LCDOUT?C	080h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00040	        PAUSE 500
	PAUSE?C	001F4h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00041	        LCDOUT "*  TBOLT VMOn V3.3*"
	LCDOUT?C	02Ah
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	042h
	LCDOUT?C	04Fh
	LCDOUT?C	04Ch
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	04Dh
	LCDOUT?C	04Fh
	LCDOUT?C	06Eh
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	033h
	LCDOUT?C	02Eh
	LCDOUT?C	033h
	LCDOUT?C	02Ah

; C:\PBP\SAMPLES\VMON3_~2.PBP	00042	        LCDOUT $FE,$80              'MOVE LCD CURSOR TO LINE 1 COL 1
	LCDOUT?C	0FEh
	LCDOUT?C	080h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00043	        PAUSE 500
	PAUSE?C	001F4h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00044	        LCDOUT "  *TBOLT VMOn V3.3 "
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	02Ah
	LCDOUT?C	054h
	LCDOUT?C	042h
	LCDOUT?C	04Fh
	LCDOUT?C	04Ch
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	04Dh
	LCDOUT?C	04Fh
	LCDOUT?C	06Eh
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	033h
	LCDOUT?C	02Eh
	LCDOUT?C	033h
	LCDOUT?C	020h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00045	        PAUSE 500
	PAUSE?C	001F4h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00047	        HSEROUT [16,142,172,2,16,3]   'TRANSMIT CMD FOR 8FAC STATUS PACKET
	HSEROUT?C	010h
	HSEROUT?C	08Eh
	HSEROUT?C	0ACh
	HSEROUT?C	002h
	HSEROUT?C	010h
	HSEROUT?C	003h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00049	CHECKSTAT:                        'CHECK RXREG STATUS BIT 5

	LABEL?L	_CHECKSTAT	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00050	       IF PIR1.5 = 1 THEN GOto LOADDATA  
	CMPNE?TCL	_PIR1??5, 001h, L00003
	GOTO?L	_LOADDATA
	LABEL?L	L00003	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00051	       GOTO CHECKSTAT
	GOTO?L	_CHECKSTAT

; C:\PBP\SAMPLES\VMON3_~2.PBP	00053	LOADDATA:                         'LOAD RXDATA ARRAY WITH 8F-AC STATUS PACKET

	LABEL?L	_LOADDATA	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00054	        HSERIN [RXDATA [B0]] 
	HSERIN?W	T1
	AIN?BBB	T1, _RXDATA, _B0

; C:\PBP\SAMPLES\VMON3_~2.PBP	00055	        B0 = B0 + 1
	ADD?BCB	_B0, 001h, _B0

; C:\PBP\SAMPLES\VMON3_~2.PBP	00056	        IF B0 > 79 THEN GOTO AC
	CMPLE?BCL	_B0, 04Fh, L00005
	GOTO?L	_AC
	LABEL?L	L00005	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00057	        goto checkstat                    'RETURN TO CHECK RX STATUS 
	GOTO?L	_CHECKSTAT

; C:\PBP\SAMPLES\VMON3_~2.PBP	00059	AC:                               'PARSING - LOOK FOR $AC IN RXDATA ARRAY

	LABEL?L	_AC	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00060	        FOR B1 = 1 TO 80
	MOVE?CB	001h, _B1
	LABEL?L	L00007	
	CMPGT?BCL	_B1, 050h, L00008

; C:\PBP\SAMPLES\VMON3_~2.PBP	00061	        IF RXDATA [B1] = $AC THEN GOTO ALARMCHECK   'DETERMINE ALARM BYTE OFFSET
	AOUT?BBB	_RXDATA, _B1, T1
	CMPNE?BCL	T1, 0ACh, L00009
	GOTO?L	_ALARMCHECK
	LABEL?L	L00009	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00062	        NEXT B1
	NEXT?BCL	_B1, 001h, L00007
	LABEL?L	L00008	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00064	ALARMCHECK:                           'LOCATE AND CHECK FOR ALARMS

	LABEL?L	_ALARMCHECK	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00066	        MAJOR = RXDATA [B1 + 8] + RXDATA [B1 + 9]         'ASSIGN DATA TO MINOR ALARM HIGH
	ADD?BCW	_B1, 008h, T1
	AOUT?BWB	_RXDATA, T1, T1
	ADD?BCW	_B1, 009h, T2
	AOUT?BWB	_RXDATA, T2, T2
	ADD?BBB	T1, T2, _MAJOR

; C:\PBP\SAMPLES\VMON3_~2.PBP	00067	        MINOR = RXDATA [B1 + 10] + RXDATA [B1 + 11]        'ASSIGN DATA TO MINOR ALARM HIGH
	ADD?BCW	_B1, 00Ah, T1
	AOUT?BWB	_RXDATA, T1, T1
	ADD?BCW	_B1, 00Bh, T2
	AOUT?BWB	_RXDATA, T2, T2
	ADD?BBB	T1, T2, _MINOR

; C:\PBP\SAMPLES\VMON3_~2.PBP	00069	        LCDOUT $FE,$C0              'MOVE LCD CURSOR TO LINE 2 COL 1
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00070	        IF MINOR <> 0 OR MAJOR <> 0 THEN GOto DISPLAYALARMS
	CMPNE?BCB	_MINOR, 000h, T1
	CMPNE?BCB	_MAJOR, 000h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00011
	GOTO?L	_DISPLAYALARMS
	LABEL?L	L00011	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00072	        LOW LED1                   'RESET LED1
	LOW?T	_LED1

; C:\PBP\SAMPLES\VMON3_~2.PBP	00073	        LOW LED2                   'RESET LED2
	LOW?T	_LED2

; C:\PBP\SAMPLES\VMON3_~2.PBP	00074	        PAUSE 2000    
	PAUSE?C	007D0h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00075	        GOTO MAIN
	GOTO?L	_MAIN

; C:\PBP\SAMPLES\VMON3_~2.PBP	00077	DISPLAYALARMS:

	LABEL?L	_DISPLAYALARMS	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00078	        IF MAJOR <> 0 THEN HIGH LED1 'LIGHT LED1 IF MAJOR ALARMS
	CMPEQ?BCL	_MAJOR, 000h, L00013
	HIGH?T	_LED1
	LABEL?L	L00013	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00079	        IF MINOR <> 0 THEN HIGH LED2 'LIGHT LED2 IF MINOR ALARMS
	CMPEQ?BCL	_MINOR, 000h, L00015
	HIGH?T	_LED2
	LABEL?L	L00015	

; C:\PBP\SAMPLES\VMON3_~2.PBP	00080	        pause 2000
	PAUSE?C	007D0h

; C:\PBP\SAMPLES\VMON3_~2.PBP	00081	        goto main
	GOTO?L	_MAIN

; C:\PBP\SAMPLES\VMON3_~2.PBP	00083	END
	END?	

	END
